//
//  MCStaticMenuRegistry.h
//  MCApplication
//
//  Created by Ali Lalani on 07/04/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface MCStaticMenuRegistry : NSObject {
	NSMutableDictionary *_menuConfigs;
	NSMutableDictionary *_menus;
}
+ (MCStaticMenuRegistry *)defaultRegistry;

- (void)registerMenuConfigurations:(NSArray *)array;
- (void)registerMenuWithConfiguration:(NSDictionary *)dict;
- (NSMenu *)menuWithIdentifier:(NSString *)anIdentifier;
- (NSMenu*)menuWithIdentifier: (NSString*)anIdentifier setTarget: (id)aTarget actionString: (NSString*)aSelector;
- (void)generateMenuForIdentifier:(NSString *)anIdentifier;

#pragma mark Accessors
- (NSMutableDictionary *)menuConfigs;
- (void)setMenuConfigs:(NSMutableDictionary *)aMenuConfigs;
- (NSMutableDictionary *)menus;
- (void)setMenus:(NSMutableDictionary *)aMenus;
@end
